<!-- HERO SECTION – DRAINAGE & GRADING -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Drainage & Grading Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor provides professional drainage and grading solutions that help keep 
            your property safe, dry, and protected from water damage. We shape the land the 
            right way so water flows where it should — not toward your home.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Proper Drainage & Grading Matters
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Good drainage is one of the most important parts of protecting your home and 
            yard. When water sits in the wrong place, it can cause flooding, soil erosion, 
            foundation damage, dead plants, and unhealthy lawn conditions. Our team builds 
            grading and drainage systems that move water safely away from your home.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Prevents Flooding
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Moves water away from your home, lawn, and outdoor areas.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Protects Foundations
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Helps prevent cracks, sinking, and water damage around your home.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Healthier Lawn
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Prevents soggy spots, erosion, and standing water that harm plants.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Drainage & Grading Services We Offer
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Yard regrading and slope correction</li>
                <li>Drainage system installation</li>
                <li>French drains and channel drains</li>
                <li>Downspout and gutter water rerouting</li>
                <li>Swale creation and shaping</li>
                <li>Soil stabilization and erosion control</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Need Better Drainage for Your Property?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            We fix yard flooding, standing water, and grading problems with long-lasting 
            solutions built for your home. Our team handles everything from inspection 
            to installation.
        </p>

        <div style="
            margin-top:25px; 
            display:flex; 
            gap:10px; 
            align-items:center; 
            justify-content:center; 
            flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" loading="lazy" allowfullscreen>
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- DRAINAGE & GRADING – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Drainage & Grading FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Helpful answers to common drainage and grading questions.
            </p>
        </div>

        <div class="accordion" id="drainageFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drainFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#drainAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Why is grading important for my yard?
                        </button>
                    </h3>
                </div>

                <div id="drainAnswer1" class="collapse" data-parent="#drainageFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Proper grading controls how water flows across your property. It prevents 
                        flooding, soil erosion, and water pooling near your home or outdoor living areas.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drainFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#drainAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How do I know if my yard has drainage issues?
                        </button>
                    </h3>
                </div>

                <div id="drainAnswer2" class="collapse" data-parent="#drainageFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Warning signs include standing water, muddy areas, sinking soil, water near 
                        your home’s foundation, dead patches in your lawn, or flooding during rain.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drainFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#drainAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What drainage solutions do you install?
                        </button>
                    </h3>
                </div>

                <div id="drainAnswer3" class="collapse" data-parent="#drainageFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We install French drains, channel drains, swales, downspout rerouting, 
                        and custom grading systems to direct water safely away from your home.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="drainFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#drainAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can drainage work help fix standing water?
                        </button>
                    </h3>
                </div>

                <div id="drainAnswer4" class="collapse" data-parent="#drainageFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — proper grading and drainage systems are the best way to stop 
                        standing water and prevent long-term damage to your yard.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
