<!-- HERO SECTION – DRIVEWAY & WALKWAY PAVING -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Driveway & Walkway Paving Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor installs strong, stylish driveway and walkway paving built to last. 
            Whether you want a clean modern look or a classic stone design, our team creates 
            durable paths that make your home look sharp from the moment you arrive.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose Professional Paving for Your Home?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Quality paving does more than improve the look of your home — it adds strength, 
            safety, and long-term value. Our driveway and walkway installations are built with 
            durable materials that handle daily use, heat, rain, and heavy foot traffic.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Built for Strength
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Durable paving designed to handle cars, rain, and daily wear.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean, Modern Look
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Smooth finishes and stylish layouts that match your home.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Safe, Easy Walkways
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Stable, even pathways that prevent tripping and improve access.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Perfect for All Types of Homes
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Concrete or paver driveways</li>
                <li>Front walkway paving</li>
                <li>Backyard and patio paths</li>
                <li>Stone, brick, or modern paver options</li>
                <li>Raised or curved walkway designs</li>
                <li>Long-lasting driveway resurfacing</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready for a Strong, Beautiful New Driveway or Walkway?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our paving team delivers smooth, long-lasting installations with clean finishes 
            and curb appeal built right in. Get a strong surface that looks great for years.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- DRIVEWAY & WALKWAY PAVING – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Driveway & Walkway Paving FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Simple answers to common questions about paving your driveway or walkway.
            </p>
        </div>

        <div class="accordion" id="pavingFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="pavingFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#pavingAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What materials can be used for driveway or walkway paving?
                        </button>
                    </h3>
                </div>

                <div id="pavingAnswer1" class="collapse" data-parent="#pavingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We install concrete, pavers, brick, stone, and other long-lasting materials 
                        depending on the design and strength you want.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="pavingFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#pavingAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does paving installation take?
                        </button>
                    </h3>
                </div>

                <div id="pavingAnswer2" class="collapse" data-parent="#pavingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Most paving projects take one to three days depending on size, materials, 
                        and site preparation.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="pavingFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#pavingAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Does paving increase home value?
                        </button>
                    </h3>
                </div>

                <div id="pavingAnswer3" class="collapse" data-parent="#pavingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — a paved driveway or walkway adds curb appeal, improves safety, and 
                        boosts long-term property value.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="pavingFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#pavingAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How durable is walkway or driveway paving?
                        </button>
                    </h3>
                </div>

                <div id="pavingAnswer4" class="collapse" data-parent="#pavingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Very durable — quality paving can last many years with minimal upkeep, 
                        especially with strong base preparation.
                    </div>
                </div>
            </div>

            <!-- FAQ 5 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="pavingFaq5" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#pavingAnswer5"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do paved walkways help with safety?
                        </button>
                    </h3>
                </div>

                <div id="pavingAnswer5" class="collapse" data-parent="#pavingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — paved walkways create smooth, stable paths that reduce tripping 
                        and make your yard easier to navigate.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
