<!-- HERO SECTION – RETAINING WALLS -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Retaining Wall Construction
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor builds strong, clean, and long-lasting retaining walls designed to 
            support your property and add style to your outdoor space. We use high-quality 
            materials that are built to stay sturdy and look great.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose a Retaining Wall?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Retaining walls help hold soil in place, prevent erosion, and create clean, usable 
            outdoor spaces. They also add structure, shape, and design appeal to your yard. 
            We build each wall to fit your land, support your layout, and match your home’s style.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Strong Support
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Built to hold soil, prevent erosion, and support sloped areas.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean, Stylish Look
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Choose from block, stone, concrete, and other modern looks.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="background:#f6fbf6; padding:25px; border-radius:14px; height:100%; text-align:center;
                    border:1px solid rgba(0,0,0,0.06);">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Long-Lasting Build
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Designed for stability and made to last through all seasons.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Retaining Wall Options
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Block retaining walls</li>
                <li>Concrete retaining walls</li>
                <li>Stacked stone walls</li>
                <li>Tiered retaining walls</li>
                <li>Soil support and erosion control</li>
                <li>Landscape border walls</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Need a Strong, Stylish Retaining Wall?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our team designs and builds retaining walls that support your yard and improve 
            your outdoor space. Built for strength, stability, and a clean look.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- RETAINING WALLS – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <!-- H2 – SEO Optimized Heading -->
        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Retaining Wall FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Answers to common questions about retaining wall construction.
            </p>
        </div>

        <div class="accordion" id="retainingFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="retainingFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#retainingAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What does a retaining wall do?
                        </button>
                    </h3>
                </div>

                <div id="retainingAnswer1" class="collapse" data-parent="#retainingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        A retaining wall holds soil in place and helps shape your yard. It also 
                        prevents erosion and supports sloped areas, making the space more usable.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="retainingFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#retainingAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What materials can a retaining wall be made from?
                        </button>
                    </h3>
                </div>

                <div id="retainingAnswer2" class="collapse" data-parent="#retainingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We build walls using concrete, block, stone, or other durable materials 
                        depending on your design and support needs.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="retainingFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#retainingAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long do retaining walls last?
                        </button>
                    </h3>
                </div>

                <div id="retainingAnswer3" class="collapse" data-parent="#retainingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        A well-built retaining wall can last decades. Proper drainage and strong 
                        materials help it stay stable over time.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
