<section class="pt-8" style="background:#f6fbf6;">
    <div class="container">

        <!-- FEATURED IMAGE + TITLE -->
        <div class="row justify-content-center">
            <div class="col-lg-9">

                <!-- Featured Banner -->
                <div style="
                    width:100%;
                    height:360px;
                    border-radius:16px;
                    background-size:cover;
                    background-position:center;
                    background-image:url(<?php echo base_url($post->image) ?>);
                    box-shadow:0 12px 28px rgba(0,0,0,0.12);
                "></div>

                <!-- Article Title -->
                <h1 style="
                    font-size:38px;
                    font-weight:700;
                    color:#075818;
                    margin-top:32px;
                    margin-bottom:22px;
                    line-height:1.25;
                ">
                    <?php echo html_escape($post->title) ?>
                </h1>
            </div>
        </div>

        <!-- ARTICLE BODY -->
        <div class="row justify-content-center">
            <div class="col-lg-9">

                <article style="
                    font-size:19px;
                    color:#2b2b2b;
                    line-height:1.75;
                ">
                    <div style="margin-bottom:40px;">
                        <?= ($post->details) ?>
                    </div>

                    <!-- TAGS SECTION -->
                    <?php if (!empty($tags)): ?>
                    <div style="margin:50px 0;">
                        <h2 style="
                            font-size:22px;
                            font-weight:700;
                            color:#075818;
                            margin-bottom:12px;
                        ">Related Topics</h2>

                        <?php foreach ($tags as $tag): ?>
                            <a href="#" style="
                                display:inline-block;
                                background:#e9f7e9;
                                padding:6px 14px;
                                border-radius:20px;
                                margin:4px;
                                font-size:14px;
                                color:#075818;
                                text-decoration:none;
                                border:1px solid #d7efd7;
                                transition:0.2s;
                            " onmouseover="this.style.background='#d9efda'" 
                              onmouseout="this.style.background='#e9f7e9'">
                                #<?php echo html_escape($tag->tag) ?>
                            </a>
                        <?php endforeach ?>
                    </div>
                    <?php endif; ?>

                    <!-- COMMENTS SECTION -->
                    <?php if (!empty($comments)): ?>
                    <div style="margin-top:60px;">
                        <h2 style="
                            font-size:26px;
                            font-weight:700;
                            color:#075818;
                            margin-bottom:20px;
                        ">
                            Comments (<?php echo html_escape(count($comments)) ?>)
                        </h2>

                        <ul style="padding-left:0; list-style:none;">

                            <?php foreach ($comments as $comment): ?>
                            <li style="display:flex; margin-bottom:30px;">

                                <img src="<?php echo base_url() ?>assets/images/avatar.png"
                                     style="width:58px; height:58px; border-radius:50%; margin-right:15px; border:2px solid #eaeaea;">

                                <div>
                                    <h4 style="
                                        font-size:16px;
                                        margin:0;
                                        color:#075818;
                                        font-weight:600;
                                    ">
                                        <?php echo html_escape($comment->name); ?>
                                        <span style="color:#888; font-size:14px; margin-left:6px;">
                                            <?php echo get_time_ago($comment->created_at); ?>
                                        </span>
                                    </h4>

                                    <p style="margin-top:6px; font-size:16px; color:#333;">
                                        <?php echo html_escape($comment->message); ?>
                                    </p>
                                </div>
                            </li>
                            <?php endforeach ?>

                        </ul>
                    </div>
                    <?php endif; ?>

                </article>


                <!-- DISABLED REPLY FORM (kept intact, hidden) -->
                <div class="w-100 w-md-90 d-none">
                    <h3><?php echo trans('leave-a-reply') ?></h3>
                    <form method="post" action="<?php echo base_url('home/send_comment/'.html_escape($post->id)); ?>">
                        <div class="form-row">
                            <div class="col-sm">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="name" placeholder="Your Name">
                                </div>
                            </div>
                            <div class="col-sm">
                                <div class="form-group">
                                    <input type="email" class="form-control" name="email" placeholder="Email Address" required>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <textarea name="message" rows="6" class="form-control" placeholder="Your message" required></textarea>
                        </div>
                        <!-- csrf -->
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>"
                               value="<?php echo $this->security->get_csrf_hash();?>">

                        <button class="btn btn-primary btn-wide" type="submit"><?php echo trans('submit') ?></button>
                    </form>
                </div>

                <!-- CTA BOX (SEO BOOSTER) -->
                <div style="
                    margin-top:70px;
                    background:#e9f7e9;
                    padding:40px;
                    border-radius:14px;
                    text-align:center;
                    box-shadow:0 8px 22px rgba(0,0,0,0.05);
                ">
                    <h3 style="color:#075818; font-size:24px; font-weight:700; margin-bottom:15px;">
                        Want Help With Your Outdoor Project?
                    </h3>
                    <p style="color:#444; font-size:18px; margin-bottom:25px;">
                        From landscaping and hardscaping to turf installation and outdoor living,
                        Aversa Outdoor brings your vision to life.
                    </p>

                    <a class="open-quote" href="/contact" style="
                        display:inline-block;
                        background:#34a906;
                        color:#fff;
                        padding:14px 32px;
                        border-radius:30px;
                        font-size:17px;
                        text-decoration:none;
                        font-weight:600;
                        margin-right:10px;
                        transition:0.2s;
                    " onmouseover="this.style.background='#2a9005'"
                      onmouseout="this.style.background='#34a906'">
                        Get a Free Quote
                    </a>

                    <a href="tel:9412741505" style="
                        display:inline-block;
                        background:#075818;
                        color:#fff;
                        padding:14px 32px;
                        border-radius:30px;
                        font-size:17px;
                        text-decoration:none;
                        font-weight:600;
                        transition:0.2s;
                    " onmouseover="this.style.background='#064814'"
                      onmouseout="this.style.background='#075818'">
                        Call Now
                    </a>
                </div>

            </div>
        </div>
    </div>
</section>
