<!-- HERO SECTION – STONE RETAINING WALLS -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Stone Retaining Wall Construction
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor builds natural stone retaining walls that offer long-lasting 
            strength and a timeless look. Each wall is crafted with durable materials 
            designed to support your yard while adding natural beauty to your outdoor space.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose a Stone Retaining Wall?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Stone walls are both strong and stylish. They provide essential support for 
            sloped yards, reduce erosion, and bring a natural, high-end look to your 
            landscape. Each wall is built to last and shaped to fit your property perfectly.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6;
                    padding:25px;
                    border-radius:14px;
                    height:100%;
                    text-align:center;
                    border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Natural Beauty
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Stone walls blend into any landscape and stay beautiful for years.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6;
                    padding:25px;
                    border-radius:14px;
                    height:100%;
                    text-align:center;
                    border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Long-Lasting Strength
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Built with durable stones that stand strong through all seasons.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6;
                    padding:25px;
                    border-radius:14px;
                    height:100%;
                    text-align:center;
                    border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Custom Build
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Each wall is shaped and fitted to match your property and layout.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Stone Wall Options
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Stacked stone retaining walls</li>
                <li>Natural boulder walls</li>
                <li>Flagstone and fieldstone designs</li>
                <li>Decorative stone borders</li>
                <li>Tiered stone levels</li>
                <li>Stone support walls for slopes</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Want a Strong, Natural-Looking Stone Wall?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our stone retaining walls add strength, support, and beauty to your outdoor 
            space. Built by experts and made to last.
        </p>

        <div class="hero-cta-wrap" style="
            margin-top:25px;
            display:flex;
            gap:10px;
            align-items:center;
            justify-content:center;
            flex-wrap:wrap;
        ">
            <!-- Quote Button -->
            <a class="open-quote"
               style="
                   background:#34a906;
                   color:#fff;
                   padding:16px 40px;
                   border-radius:30px;
                   font-size:18px;
                   font-weight:600;
                   text-decoration:none;
                   transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                   background:#ffffff;
                   color:#34a906;
                   border:2px solid #34a906;
                   padding:12px 20px;
                   border-radius:50px;
                   font-weight:600;
                   font-size:16px;
                   text-decoration:none;
                   display:flex;
                   align-items:center;
                   gap:7px;
               ">
                <i class="bi bi-telephone-fill"></i> Call Now
            </a>
        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- STONE RETAINING WALLS – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <!-- H2 – SEO Optimized Heading -->
        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Stone Retaining Wall FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Helpful answers about natural stone retaining walls.
            </p>
        </div>

        <div class="accordion" id="stoneRetainingFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="stoneRetainingFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#stoneRetainingAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Are stone retaining walls stronger than block walls?
                        </button>
                    </h3>
                </div>

                <div id="stoneRetainingAnswer1" class="collapse" data-parent="#stoneRetainingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Stone walls offer excellent strength and a natural look. Block walls can be 
                        more uniform, but stone gives a more classic, timeless style with great durability.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="stoneRetainingFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#stoneRetainingAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do stone retaining walls need drainage?
                        </button>
                    </h3>
                </div>

                <div id="stoneRetainingAnswer2" class="collapse" data-parent="#stoneRetainingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes. Proper drainage keeps your wall strong and prevents pressure buildup 
                        behind the stones. We install drainage systems with every wall.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="stoneRetainingFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button"
                            data-toggle="collapse"
                            data-target="#stoneRetainingAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long do stone retaining walls last?
                        </button>
                    </h3>
                </div>

                <div id="stoneRetainingAnswer3" class="collapse" data-parent="#stoneRetainingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Stone retaining walls can last for decades. Natural stone is strong, weather-resistant, 
                        and keeps its look over time.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
