<!-- HERO SECTION – TREE REMOVAL -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Tree Removal Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor provides safe, professional tree removal for unwanted, damaged, 
            or hazardous trees. We remove trees carefully to protect your home, yard, and 
            surrounding structures.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Safe & Professional Tree Removal
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Whether a tree is dead, leaning, storm-damaged, or simply in the way of a new 
            project, our team removes it safely and efficiently. We use proper equipment, 
            follow strict safety steps, and clean up the area when the job is done.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Safe Removal
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        We remove trees without harming nearby homes, fences, or landscaping.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Storm-Damaged Trees
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        We handle fallen, cracked, or weakened trees before they cause damage.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Full Cleanup
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Branches, debris, and trunk pieces are removed, leaving your yard clean.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            When to Remove a Tree
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Dead or dying trees</li>
                <li>Storm-damaged or leaning trees</li>
                <li>Trees growing too close to your home</li>
                <li>Roots causing damage to driveways or foundations</li>
                <li>Trees blocking new construction or landscaping</li>
                <li>Unsafe branches or falling hazards</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Need a Tree Removed Safely & Quickly?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our team removes unwanted or hazardous trees using safe and reliable methods. 
            We protect your property and leave your space clean and ready for your next project.
        </p>

        <div style="
            margin-top:25px; 
            display:flex; 
            gap:10px; 
            align-items:center; 
            justify-content:center; 
            flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" loading="lazy" allowfullscreen>
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- TREE REMOVAL – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Tree Removal FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Common questions about removing trees safely and preparing your space.
            </p>
        </div>

        <div class="accordion" id="treeFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="treeFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#treeAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            When should I remove a tree?
                        </button>
                    </h3>
                </div>

                <div id="treeAnswer1" class="collapse" data-parent="#treeFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Trees should be removed when they are dead, leaning, storm-damaged, 
                        or becoming a hazard. Trees too close to your home or roots causing damage 
                        may also need removal.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="treeFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#treeAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do you remove all branches and debris?
                        </button>
                    </h3>
                </div>

                <div id="treeAnswer2" class="collapse" data-parent="#treeFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we remove all debris, branches, and trunk pieces. We leave 
                        your yard clean and ready for your next project.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="treeFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#treeAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can you remove tree stumps too?
                        </button>
                    </h3>
                </div>

                <div id="treeAnswer3" class="collapse" data-parent="#treeFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — stump removal or grinding can be added to your tree removal 
                        service for a clean, level finish.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="treeFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#treeAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Is tree removal dangerous?
                        </button>
                    </h3>
                </div>

                <div id="treeAnswer4" class="collapse" data-parent="#treeFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Removing trees can be dangerous without the right equipment or training. 
                        Our team uses safe methods and protective gear to ensure the job is done 
                        correctly and safely.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
