<div class="content-wrapper">
    
    <!-- Content Header (Page header) -->
    <?php include"include/breadcrumb.php"; ?>

    <!-- Main content -->
    <div class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col-md-6 -->
          <div class="col-lg-12">
            <div class="card">

              <div class="">
                <div class="row">
                  <div class="col-md-3">
                    <div class="card-body">
                      <ul class="nav nav-pills flex-column" id="myTab" role="tablist">
                        <li class="nav-item">
                          <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true"><i class="lni lni-cog mr-1"></i> <?php echo trans('website-settings') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="appearance-tab" data-toggle="tab" href="#appearance" role="tab" aria-controls="appearance" aria-selected="false"><i class="fas fa-paint-brush mr-1"></i> <?php echo trans('appearance') ?> </a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="prefrences-tab" data-toggle="tab" href="#prefrences" role="tab" aria-controls="prefrences" aria-selected="false"><i class="lnib lni-invention mr-1"></i> <?php echo trans('prefrences') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="openai-tab" data-toggle="tab" href="#openai" role="tab" aria-controls="openai" aria-selected="false"><i class="fas fa-robot mr-1"></i><?php echo trans('openai-api') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="charts-tab" data-toggle="tab" href="#charts" role="tab" aria-controls="charts" aria-selected="false"><i class="lnib lni-stats-up mr-1"></i> <?php echo trans('charts') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="calendar-tab" data-toggle="tab" href="#calendar" role="tab" aria-controls="calendar" aria-selected="false"><i class="far fa-calendar-alt mr-1"></i> <?php echo trans('calendar-settings') ?> </a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="sociallog-tab" data-toggle="tab" href="#sociallog" role="tab" aria-controls="sociallog" aria-selected="false"><i class="fas fa-sign-in-alt mr-1"></i> <?php echo trans('social-login') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="sms-tab" data-toggle="tab" href="#sms" role="tab" aria-controls="sms" aria-selected="false"><i class="far fa-comment-dots mr-1"></i> Twilio <?php echo trans('sms-settings') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="whatsapp-tab" data-toggle="tab" href="#whatsapp" role="tab" aria-controls="whatsapp" aria-selected="false"><i class="fab fa-whatsapp mr-1"></i> <?php echo trans('whatsapp').' '.trans('settings') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="pwa-tab" data-toggle="tab" href="#pwa" role="tab" aria-controls="mail" aria-selected="false"><i class="bi bi-phone mr-1"></i> <?php echo trans('pwa-settings') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="mail-tab" data-toggle="tab" href="#mail" role="tab" aria-controls="mail" aria-selected="false"><i class="bi bi-envelope-open mr-1"></i> <?php echo trans('email-settings') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="tax-tab" data-toggle="tab" href="#tax" role="tab" aria-controls="tax" aria-selected="false"><i class="bi bi-percent mr-1"></i> <?php echo trans('subscription-tax') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="captcha-tab" data-toggle="tab" href="#captcha" role="tab" aria-controls="captcha" aria-selected="false"><i class="bi bi-lock mr-1"></i> reCaptcha V2 <?php echo trans('settings') ?></a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="script-tab" data-toggle="tab" href="#script" role="tab" aria-controls="script" aria-selected="false"><i class="bi bi-code mr-1"></i> <?php echo trans('header-script-codes') ?> </a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="css-tab" data-toggle="tab" href="#css" role="tab" aria-controls="script" aria-selected="false"><i class="bi bi-braces-asterisk mr-1"></i> <?php echo trans('custom-css') ?> </a>
                        </li>
                        <li class="nav-item">
                          <a class="nav-link" id="social-tab" data-toggle="tab" href="#social" role="tab" aria-controls="social" aria-selected="false"><i class="bi bi-facebook mr-1"></i> <?php echo trans('social-settings') ?></a>
                        </li>

                        <li class="nav-item">
                          <a class="nav-link" id="api-tab" data-toggle="tab" href="#api" role="tab" aria-controls="api" aria-selected="false"><i class="bi bi-gear mr-1"></i> Custom API</a>
                        </li>
                      </ul>
                    </div>
                  </div>

                  <!-- col-md-4 -->
                  <div class="col-md-9">
                    <form method="post" enctype="multipart/form-data" action="<?php echo base_url('admin/settings/update') ?>" role="form" class="form-horizontal pl-20">
                      <div class="tab-content custom card-body" id="myTabContent">
                        
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                  
                            <div class="row mb-4">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                      <div class="col-sm-12">
                                        <div class="mih-100">
                                          <img class="m-auto" width="50px" src="<?php echo base_url($settings->favicon); ?>">
                                        </div>

                                        <div class="form-group">
                                          <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="photo1"  id="customFile">
                                            <label class="custom-file-label" for="customFile"><?php echo trans('upload-favicon') ?></label>
                                          </div>
                                        </div>

                                      </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                      <div class="col-sm-12">
                                        <div class="mih-100">
                                          <img class="m-auto" width="150px" src="<?php echo base_url($settings->logo); ?>">
                                        </div>

                                        <div class="form-group mb-0">
                                            <div class="custom-file">
                                              <input type="file" class="custom-file-input" name="photo2" id="customFile">
                                              <label class="custom-file-label" for="customFile"><?php echo trans('upload-logo') ?></label>
                                            </div>
                                        </div>
                                        <p class="text-muted mt-1 fs-12 small"><?php echo trans('logo-suggestions') ?></p>
                                      </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                      <div class="col-sm-12">
                                        <div class="mih-100">
                                          <img class="m-auto" width="150px" src="<?php echo base_url($settings->logo_light); ?>">
                                        </div>

                                        <div class="form-group mb-0">
                                            <div class="custom-file">
                                              <input type="file" class="custom-file-input" name="photo4" id="customFile">
                                              <label class="custom-file-label" for="customFile"><?php echo trans('upload-logo') ?> <?php echo trans('light') ?></label>
                                            </div>
                                        </div>
                                        <p class="text-muted mt-1 fs-12 small"><?php echo trans('logo-suggestions') ?></p>
                                      </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <div class="col-sm-12">
                                          <div class="mih-100">
                                          <img class="m-auto" width="100px" src="<?php echo base_url($settings->hero_img); ?>">
                                        </div>

                                        <div class="form-group">
                                            <div class="custom-file">
                                              <input type="file" class="custom-file-input" name="photo3" id="customFile">
                                              <label class="custom-file-label" for="customFile"><?php echo trans('upload-hero-image') ?></label>
                                            </div>
                                        </div>
                                      </div>
                                    </div>
                                </div>
                            </div>


                            <div class="row mb-4">
                              <div class="col-12">
                                <ul class="nav nav-tabs mb-4" role="tablist">
                                    <?php $i=1; foreach ($settings_language as $language): ?>
                                      <li class="nav-item" role="presentation">
                                        <a class="nav-link <?php if($i==1){echo "active";} ?>" id="home-tab<?php echo $i ?>" data-toggle="tab" data-target="#language_<?php echo html_escape($language->lang_id) ?>" type="button" role="tab" aria-controls="home" aria-selected="true"><?php echo get_by_id($language->lang_id,'language')->name; ?></a>
                                      </li>
                                    <?php $i++; endforeach ?>
                                </ul>

                              
                                <div class="tab-content" id="myTabContent">

                                    <?php $a=1; foreach ($settings_language as $language): ?>
                                      <div class="tab-pane fade <?php if($a==1){echo "show active";} ?>" id="language_<?php echo html_escape($language->lang_id) ?>" role="tabpanel" aria-labelledby="home-tab<?php echo $a ?>">

                                          <div class="form-group">
                                            <label><?php echo trans('application-name') ?></label>
                                            <input type="text" name="site_name[]" value="<?php echo html_escape($language->site_name); ?>" class="form-control" >
                                          </div>

                                          <div class="form-group">
                                            <label><?php echo trans('application-title') ?></label>
                                            <input type="text" name="site_title[]" value="<?php echo html_escape($language->site_title); ?>" class="form-control">
                                          </div>

                                          <div class="form-group">
                                            <label><?php echo trans('keywords') ?></label>
                                              <input type="text" data-role="tagsinput" name="keywords[]" value="<?php echo html_escape($language->keywords); ?>" class="form-control" >
                                          </div>

                                          <div class="form-group">
                                              <label><?php echo trans('description') ?></label>
                                              <textarea class="form-control" name="description[]" rows="4"><?php echo html_escape($language->description); ?></textarea>
                                          </div>

                                          <div class="form-group">
                                            <label><?php echo trans('footer-about') ?></label>
                                            <textarea class="form-control" name="footer_about[]"><?php echo html_escape($language->footer_about); ?></textarea>
                                          </div>

                                          <div class="form-group">
                                            <label><?php echo trans('copyright') ?></label>
                                            <input type="text" name="copyright[]" class="form-control" value="<?php echo html_escape($language->copyright); ?>">
                                          </div>

                                          <input type="hidden" name="lang_id[]" value="<?php echo html_escape($language->id); ?>">
                                         
                                      </div>
                                    <?php $a++; endforeach ?>
                                  
                                </div>
                              
                              </div>
                            </div>



                            <div class="form-group">
                              <label><?php echo trans('admin-email') ?></label>
                              <input type="text" name="admin_email" class="form-control" value="<?php echo html_escape(user()->email); ?>">
                              <!-- <p class="small text-muted"><i class="fa fa-info-circle"></i> <?php //echo trans('settings-email-info') ?></p> -->
                            </div>

                          

                            <div class="row">

                              <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo trans('currency') ?></label>
                                    <select class="form-control single_select" name="country">
                                        <option value=""><?php echo trans('select') ?></option>
                                        <?php foreach ($currencies as $currency): ?>
                                            <?php if (!empty($currency->currency_name)): ?>
                                              <option value="<?php echo html_escape($currency->id); ?>" 
                                                <?php echo (settings()->country == $currency->id) ? 'selected' : ''; ?>>
                                                <?php echo html_escape($currency->name.'  -  '.$currency->currency_code.' ('.$currency->currency_symbol.')'); ?>
                                              </option>
                                            <?php endif ?>
                                        <?php endforeach ?>
                                    </select>
                                </div>
                              </div>

                              <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo trans('currency-position') ?></label>
                                    <select class="form-control" name="curr_locate">
                                        <option value=""><?php echo trans('select') ?></option>
                                        <option value="0" <?php if(settings()->curr_locate == 0){echo "selected";} ?>>$ 100 </option>
                                        <option value="1" <?php if(settings()->curr_locate == 1){echo "selected";} ?>>100 $</option>
                                    </select>
                                </div>
                              </div>
                              
                              <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo trans('number-format') ?></label>
                                    <select class="form-control" name="num_format">
                                        <option value=""><?php echo trans('select') ?></option>
                                        <option value="0" <?php if(settings()->num_format == 0){echo "selected";} ?>>100 </option>
                                        <option value="2" <?php if(settings()->num_format == 2){echo "selected";} ?>>100.00</option>
                                    </select>
                                </div>
                              </div>
                             
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label><?php echo trans('set-trial-days') ?></label>
                                  <input type="number" name="trial_days" class="form-control" value="<?php echo html_escape($settings->trial_days); ?>">
                                  <p class="small text-muted"><i class="fa fa-info-circle"></i> <?php echo trans('set-0-to-disable-the-trial-option') ?></p>
                                </div>
                              </div>

                              <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo trans('time-zone') ?></label>
                                    <select class="cus_lh select2" name="time_zone" style="width: 100%;">
                                        <option value=""><?php echo trans('select') ?></option>
                                        <?php foreach ($time_zones as $time): ?>
                                            <option value="<?php echo html_escape($time->id); ?>" 
                                                <?php echo (settings()->time_zone == $time->id) ? 'selected' : ''; ?>>
                                                <?php echo html_escape($time->name); ?>
                                            </option>
                                        <?php endforeach ?>
                                    </select>
                                </div>
                              </div>

                              <div class="col-md-6">
                               <div class="form-group mb-4">
                                  <label><?php echo trans('reminder-before') ?></label>
                                  <select class="form-control" name="reminder_before">
                                      <option value="1 day"><?php echo trans('select') ?></option>

                                      
                                      <?php //for ($i=1; $i < 24 ; $i++): ?>
                                          <!-- <option value="<?php //echo html_escape($i) ?> hour" <?php //if(settings()->reminder_before == $i. ' hour'){echo "selected";} ?>> <?php //echo html_escape($i) ?> <?php //echo trans('hours') ?></option> -->
                                      <?php //endfor; ?>

                                      <?php for ($i=1; $i < 21 ; $i++): ?>
                                          <option value="<?php echo html_escape($i) ?> day" <?php if(settings()->reminder_before == $i. ' day'){echo "selected";} ?>> <?php echo html_escape($i) ?> <?php echo trans('days') ?></option>
                                      <?php endfor; ?>
                                      
                                  </select>
                                </div>
                              </div>

                              <div class="col-md-6">
                                <div class="form-group">
                                  <label><?php echo trans('card-processing-fee') ?></label>
                                  
                                  <div class="input-group">
                                    <input type="text" class="form-control" name="card_fee" value="<?php echo html_escape($settings->card_fee); ?>">
                                    <div class="input-group-append">
                                      <span class="input-group-text"><?php echo settings()->currency_symbol ?></span>
                                    </div>
                                  </div>
                                  <p class="small text-danger mt-1"><i class="fa fa-info-circle"></i> <?php echo trans('set-0-to-disable-this-option') ?></p>

                                </div>
                              </div>

                            </div>

                        </div>


                        <!-- apprance tab -->
                        <div class="tab-pane fade" id="appearance" role="tabpanel" aria-labelledby="appearance-tab">
                            
                            <div class="d-hides">
                              <p class="mb-2 font-weight-bold"><?php echo trans('frontend-color') ?></p>
                              <input type="text" name="site_color" value="<?php echo $settings->site_color; ?>" class="form-control w-50 colorpicker d-block mb-3" autocomplete="off" style="color: #fff; text-shadow: 0 0 5px #111; background: #<?php echo $settings->site_color; ?>;">
                            </div>

                            <p class="mb-2 mt-3 pt-3 font-weight-bold"></p>

                            <div class="row mb-4">
                              <div class="col-6">
                                <label class="add-pointer">
                                <div class="icheck-primary text-left radio mt-2 pb-3">
                                  <input type="radio" id="radioPrimaryl" value="1" name="home_layout" <?php if($settings->home_layout == '1'){echo "checked";} ?>>
                                  <label for="radioPrimaryl"> Landing Template 1
                                  </label>
                                </div>
                                <img width="80%" class="img-thumbnail shadow" src="<?php echo base_url('assets/admin/images/landing1.png') ?>">
                                </label>
                              </div>

                              <div class="col-6">
                                <label class="add-pointer">
                                <div class="icheck-primary text-left radio mt-2 pb-3">
                                  <input type="radio" id="radioPrimaryd" value="2" name="home_layout" <?php if($settings->home_layout == '2'){echo "checked";} ?>>
                                  <label for="radioPrimaryd"> Landing Template 2
                                  </label>
                                </div>
                                <img width="80%" class="img-thumbnail shadow" src="<?php echo base_url('assets/admin/images/landing2.png') ?>">
                                </label>
                              </div>
                            </div>


                            <div class="row">
                              <div class="col-12 mb-2">
                                <h6><?php echo trans('site-color-mode') ?></h6>
                              </div>

                              <div class="col-6">
                                <label class="add-pointer">
                                <div class="icheck-primary text-left radio mt-2 pb-3">
                                  <input type="radio" id="stmode1" value="light" name="site_mode" <?php if($settings->site_mode == 'light'){echo "checked";} ?>>
                                  <label for="stmode1"> <?php echo trans('light') ?>
                                  </label>
                                </div>
                                <img width="80%" class="img-thumbnail d-noneg shadow" src="<?php echo base_url('assets/images/light_panel.png') ?>">
                                </label>
                              </div>

                              <div class="col-6">
                                <label class="add-pointer">
                                <div class="icheck-primary text-left radio mt-2 pb-3">
                                  <input type="radio" id="stmode2" value="dark" name="site_mode" <?php if($settings->site_mode == 'dark'){echo "checked";} ?>>
                                  <label for="stmode2"> <?php echo trans('dark') ?>
                                  </label>
                                </div>
                                <img width="80%" class="img-thumbnail d-noneg shadow" src="<?php echo base_url('assets/images/dark_panel.png') ?>">
                                </label>
                              </div>
                            </div>


                            <div class="row d-none">
                              <div class="col-6">
                                <label class="add-pointer">
                                <div class="icheck-primary text-left radio mt-2 pb-3">
                                  <input type="radio" id="radioPrimaryl" value="1" name="layout" <?php if($settings->layout == '1'){echo "checked";} ?>>
                                  <label for="radioPrimaryl"> <?php echo trans('light').' '.trans('sidebar') ?>
                                  </label>
                                </div>
                                <img width="60%" class="img-thumbnail shadow" src="<?php echo base_url('assets/admin/images/light.png') ?>">
                                </label>
                              </div>

                              <div class="col-6">
                                <label class="add-pointer">
                                <div class="icheck-primary text-left radio mt-2 pb-3">
                                  <input type="radio" id="radioPrimaryd" value="0" name="layout" <?php if($settings->layout == '0'){echo "checked";} ?>>
                                  <label for="radioPrimaryd"> <?php echo trans('dark').' '.trans('sidebar') ?>
                                  </label>
                                </div>
                                <img width="60%" class="img-thumbnail shadow" src="<?php echo base_url('assets/admin/images/dark.png') ?>">
                                </label>
                              </div>
                            </div>
                        </div>

                        <!-- prefrences tab -->
                        <div class="tab-pane fade" id="prefrences" role="tabpanel" aria-labelledby="prefrences-tab">
                            <div class="form-group">
                                <div class="col-sm-12 mt-15">

                                  <div class="custom-control custom-switch prefrence-item ml-10">
                                      <input type="checkbox" name="enable_openai" class="custom-control-input" value="1" id="switch-ai" <?php if($settings->enable_openai == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-ai"><?php echo trans('openai-api') ?></label>
                                      <p class="text-muted"><small><?php echo trans('enable-openai') ?>.</small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10">
                                      <input type="checkbox" name="enable_cdomain" class="custom-control-input" value="1" id="switch-cd" <?php if($settings->enable_cdomain == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-cd"><?php echo trans('custom-domain') ?></label>
                                      <p class="text-muted"><small><?php echo trans('enable-cdomain') ?>.</small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10">
                                      <input type="checkbox" name="enable_multilingual" class="custom-control-input" value="1" id="switch-88" <?php if($settings->enable_multilingual == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-88"><?php echo trans('multilingual-system') ?></label>
                                      <p class="text-muted"><small><?php echo trans('enable-multilingual') ?>.</small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10">
                                      <input type="checkbox" name="enable_frontend" class="custom-control-input" value="1" id="switch-11" <?php if($settings->enable_frontend == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-11"><?php echo trans('enable-frontend') ?></label>
                                      <p class="text-muted"><small><?php echo trans('enable-to-show-frontend-site') ?>.</small></p>
                                  </div>
                                  
                                  <div class="custom-control custom-switch prefrence-item ml-10">
                                      <input type="checkbox" name="enable_registration" class="custom-control-input" value="1" id="switch-2" <?php if($settings->enable_registration == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-2"><?php echo trans('registration-system') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('registration-title') ?>.</small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_captcha" class="custom-control-input" value="1" id="switch-1" <?php if($settings->enable_captcha == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-1">reCaptcha</label>
                                      <p class="text-muted mb-2"><small><?php echo trans('recaptcha-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_lifetime" class="custom-control-input" value="1" id="switch-12" <?php if($settings->enable_lifetime == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-12"><?php echo trans('enable-lifetime') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('enable-lifetime-title') ?>.</small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_coupon" class="custom-control-input" value="1" id="switch-13" <?php if($settings->enable_coupon == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-13"><?php echo trans('coupons') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('enable-coupon-title') ?>.</small></p>
                                  </div>

                                  <?php if (get_user_info() == TRUE): ?>
                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_payment" class="custom-control-input" value="1" id="switch-9" <?php if($settings->enable_payment == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-9"><?php echo trans('payment') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('payment-title') ?>.</small></p>
                                  </div>
                                  <?php else: ?>
                                      <input type="hidden" name="enable_payment" value="0">
                                  <?php endif ?>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_sms" class="custom-control-input" value="1" id="switch-10" <?php if($settings->enable_sms == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-10"><?php echo trans('sms-verification') ?></label>
                                      <p class="text-muted mb-0"><small><?php echo trans('sms-title1') ?></small></p>

                                      <p class="text-danger mb-2"><small><?php echo trans('sms-title2') ?>.</small></p>
                                  </div>


                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_email_verify" class="custom-control-input" value="1" id="switch-3" <?php if($settings->enable_email_verify == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-3"><?php echo trans('email-verification') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('email-verify-title') ?>.</small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_users" class="custom-control-input" value="1" id="switch-4" <?php if($settings->enable_users == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-4"><?php echo trans('company-list') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('company-list-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_blog" class="custom-control-input" value="1" id="switch-5" <?php if($settings->enable_blog == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-5"><?php echo trans('blogs') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('blogs-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_faq" class="custom-control-input" value="1" id="switch-6" <?php if($settings->enable_faq == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-6"><?php echo trans('faqs') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('faq-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_feature" class="custom-control-input" value="1" id="switch-8" <?php if($settings->enable_feature == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-8"><?php echo trans('features-intro') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('features-intro-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_workflow" class="custom-control-input" value="1" id="switch-7" <?php if($settings->enable_workflow == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-7"><?php echo trans('workflow') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('workflow-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_animation" class="custom-control-input" value="1" id="switch-an" <?php if($settings->enable_animation == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="switch-an"><?php echo trans('site-animation') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('site-animation-title') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_default_tzone" class="custom-control-input" value="1" id="tzone" <?php if($settings->enable_default_tzone == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="tzone"><?php echo trans('enable-default-time-zone') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('default-time-zone-tiltle') ?></small></p>
                                  </div>

                                  <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                      <input type="checkbox" name="enable_embed_badge" class="custom-control-input" value="1" id="embed_badge" <?php if($settings->enable_embed_badge == 1){echo "checked";} ?>>
                                      <label class="custom-control-label" for="embed_badge"><?php echo trans('enable-embded-badge') ?></label>
                                      <p class="text-muted mb-2"><small><?php echo trans('embded-badge-tiltle') ?></small></p>
                                  </div>

                                </div>
                            </div>
                        </div>


                        <!-- openai tab -->
                        <div class="tab-pane fade" id="openai" role="tabpanel" aria-labelledby="openai-tab">
                          <?php if (settings()->type == 'live'): ?>
                            <div class="col-6">
                              <div class="form-group">
                                <label><?php echo trans('openai-api-key') ?></label>
                                  <input type="text" name="openai_key" value="<?php echo html_escape($settings->openai_key); ?>" class="form-control">
                              </div>
                              
                              <div class="form-group">
                                <label><?php echo trans('openai-model') ?></label>
                                <select name="openai_model" class="form-control">
                                    <?php $m=1; foreach (get_openai_models() as $model): ?>
                                      <option value="<?php echo html_escape($model) ?>" <?php echo ($model == $settings->openai_model) ? "selected" : ""; ?>><?php echo html_escape($model) ?></option>
                                    <?php $m++; endforeach ?>
                                </select>
                              </div>
                            </div>
                          <?php else: ?>
                            <div class="col-6">
                              <div class="form-group">
                                <p class="mb-0"><i class="fas fa-info-circle"></i> API Info is restricted on demo mode</p>
                              </div>
                            </div>
                          <?php endif ?>
                        </div>



                        <!-- charts tab -->
                        <div class="tab-pane fade" id="charts" role="tabpanel" aria-labelledby="charts-tab">
                            <p class="mb-3"><?php echo trans('select-income-chart-style') ?></p>

                            <div class="icheck-primary radio mt-2 pb-3">
                              <input type="radio" id="radioPrimary1" value="column" name="chart_style" <?php if($settings->chart_style == 'column'){echo "checked";} ?>>
                              <label for="radioPrimary1"><i class="fas fa-chart-bar fa-2x ml-2"></i> <?php echo trans('bar-chart') ?>
                              </label>
                            </div>

                            <div class="icheck-primary radio pb-3">
                              <input type="radio" id="radioPrimary2" value="line" name="chart_style" <?php if($settings->chart_style == 'line'){echo "checked";} ?>>
                              <label for="radioPrimary2"><i class="fas fa-chart-line fa-2x ml-2"></i> <?php echo trans('line-chart') ?>
                              </label>
                            </div>

                            <div class="icheck-primary radio pb-3">
                              <input type="radio" id="radioPrimary3" value="area" name="chart_style" <?php if($settings->chart_style == 'area'){echo "checked";} ?>>
                              <label for="radioPrimary3"><i class="fas fa-chart-area fa-2x ml-2"></i> <?php echo trans('area-line-chart') ?>
                              </label>
                            </div>

                            <div class="icheck-primary radio pb-3">
                              <input type="radio" id="radioPrimary4" value="areaspline" name="chart_style" <?php if($settings->chart_style == 'areaspline'){echo "checked";} ?>>
                              <label for="radioPrimary4"><i class="fas fa-chart-area fa-2x ml-2"></i> <?php echo trans('area-shape-chart') ?>
                              </label>
                            </div>
                        </div>


                        <!-- calendar tab -->
                        <div class="tab-pane fade" id="calendar" role="tabpanel" aria-labelledby="calendar-tab">
                            <p>
                              <span class="badge badge-primary-soft fs-15 mr-4"><?php echo trans('google-calendar') ?></span>
                              <a target="_blank" class="pull-right" href="<?php echo base_url('assets/admin/files/google_calendar.pdf') ?>"><span class="btn btn-outline-danger btn-sm"><i class="fas fa-info-circle"></i> <?php echo trans('google-calendar-integration') ?></span></a>
                            </p>

                            <div class="form-group">
                              <label><?php echo trans('client-id') ?></label>
                                <input type="text" name="google_client_id" value="<?php echo html_escape($settings->google_client_id); ?>" class="form-control" >
                            </div>

                            <div class="form-group">
                              <label><?php echo trans('client-secret') ?></label>
                                <input type="text" name="google_client_secret" value="<?php echo html_escape($settings->google_client_secret); ?>" class="form-control" >
                            </div>

                            <div class="form-group bg-light-primary">
                              <p class="mb-1 mt-4"><?php echo trans('google-callback-url') ?></p>
                              <code class="badge badge-secondary-soft fs-14"><?php echo base_url('gc/auth/oauth') ?></code>
                            </div>
                        </div>

                        <!-- social login tab -->
                        <div class="tab-pane fade" id="sociallog" role="tabpanel" aria-labelledby="sociallog-tab">
                            <div class="row">
                              <div class="col-md-6 pr-3">
                                <div class="form-group">
                                  <a target="_blank" href="<?php echo base_url('docs/#idocs_google') ?>"><span class="badge badge-danger"><i class="bi bi-file-text"></i> <?php echo trans('integration-docs') ?> <i class="bi bi-arrow-right"></i></span></a>

                                  <div class="custom-control custom-switch prefrence-item pt-6">
                                    <input type="checkbox" <?php if(get_system_settings('enable_google') == 1){echo "checked";} ?> value="1" name="enable_google" class="custom-control-input" id="switch-glog" aria-invalid="false">
                                    <label class="custom-control-label" for="switch-glog"><?php echo trans('google').' '.trans('login') ?></label>
                                    <p class="mb-2"></p>
                                  </div>
                                </div>

                                <div class="form-group">
                                  <label><?php echo trans('google') ?> <?php echo trans('client-id') ?></label>
                                    <input type="text" name="google_client_id_log" value="<?php echo html_escape(get_system_settings('google_client_id')); ?>" class="form-control">
                                </div>

                                <div class="form-group">
                                  <label><?php echo trans('google') ?> <?php echo trans('secret-key') ?></label>
                                    <input type="text" name="google_secret_key" value="<?php echo html_escape(get_system_settings('google_secret_key')); ?>" class="form-control" >
                                </div>

                                <div class="form-group">
                                  <label><?php echo trans('redirect-url') ?></label>
                                    <input type="text" name="google_redirect" value="<?php echo base_url('login') ?>" class="form-control" disabled>
                                </div>
                              </div>

                              <div class="col-md-6 pl-3">
                                <div class="form-group">
                                  <a target="_blank" href="<?php echo base_url('docs/#idocs_facebook') ?>"><span class="badge badge-info"><i class="bi bi-file-text"></i> <?php echo trans('integration-docs') ?> <i class="bi bi-arrow-right"></i></span></a>

                                  <div class="custom-control custom-switch prefrence-item pt-6">
                                    <input type="checkbox" <?php if(get_system_settings('enable_facebook') == 1){echo "checked";} ?> value="1" name="enable_facebook" class="custom-control-input" id="switch-flog" aria-invalid="false">
                                    <label class="custom-control-label" for="switch-flog"><?php echo trans('facebook').' '.trans('login') ?></label>
                                    <p class="mb-2"></p>
                                  </div>
                                </div>

                                <div class="form-group">
                                  <label><?php echo trans('facebook-app-id') ?></label>
                                    <input type="text" name="facebook_app_id" value="<?php echo html_escape(get_system_settings('facebook_app_id')); ?>" class="form-control" >
                                </div>

                                <div class="form-group">
                                  <label><?php echo trans('facebook-app-secret') ?></label>
                                    <input type="text" name="facebook_app_secret" value="<?php echo html_escape(get_system_settings('facebook_app_secret')); ?>" class="form-control">
                                </div>
                                <div class="form-group">
                                  <label><?php echo trans('graph-version') ?></label>
                                    <input type="text" name="facebook_graph_version" value="<?php echo html_escape(get_system_settings('facebook_graph_version')); ?>" class="form-control" >
                                </div>
                              </div>
                            </div>
                        </div>

                        <!-- sms tab -->
                        <div class="tab-pane fade" id="sms" role="tabpanel" aria-labelledby="sms-tab">

                            <div class="form-group">
                                <div class="custom-control custom-switch prefrence-item pt-10">
                                  <input type="checkbox" <?php if($settings->global_twilio == 1){echo "checked";} ?> value="1" name="global_twilio" class="custom-control-input" id="switch-tg" aria-invalid="false">
                                  <label class="custom-control-label" for="switch-tg"><?php echo trans('enable-globally') ?></label>
                                  <p class="small text-muted"><?php echo trans('enable-globally-twilio') ?></p>
                                </div>
                            </div>

                            <div class="form-group">
                              <label><?php echo trans('account-sid') ?></label>
                                <input type="text" name="twillo_account_sid" value="<?php echo html_escape($settings->twillo_account_sid); ?>" class="form-control" >
                            </div>

                            <div class="form-group">
                              <label><?php echo trans('auth-token') ?></label>
                                <input type="text" name="twillo_auth_token" value="<?php echo html_escape($settings->twillo_auth_token); ?>" class="form-control" >
                            </div>

                            <div class="form-group">
                              <label><?php echo trans('sender-number-tw') ?></label>
                                <input type="text" name="twillo_number" value="<?php echo html_escape($settings->twillo_number); ?>" class="form-control" >
                            </div>
                        </div>

                        <!-- whatsapp tab -->
                        <div class="tab-pane fade" id="whatsapp" role="tabpanel" aria-labelledby="whatsapp-tab">
                            
                            <div class="form-group">
                                <div class="custom-control custom-switch prefrence-item pt-10">
                                  <input type="checkbox" <?php if($settings->global_wapp_msg == 1){echo "checked";} ?> value="1" name="global_wapp_msg" class="custom-control-input" id="switch-wg" aria-invalid="false">
                                  <label class="custom-control-label" for="switch-wg"><?php echo trans('enable-globally') ?></label>
                                  <p class="small mb-0 mt-2 text-success"><?php echo trans('enable-admin-api-will') ?></p>
                                  <p class="small text-warning"><?php echo trans('disable-each-user-will-connect') ?></p>
                                </div>
                            </div>

                            <div class="row">
                              
                              <div class="col-md-12">
                                <div class="form-group mb-4">
                                  <label><?php echo trans('active') ?> <?php echo trans('whatsapp') ?> <?php echo trans('type') ?></label>
                                  <select name="whatsapp_type" class="form-control">
                                      <option value="ultramsg" <?php echo ('ultramsg' == $settings->whatsapp_type) ? "selected" : ""; ?>><?php echo trans('ultramsg') ?></option>
                                      <option value="wazfy" <?php echo ('wazfy' == $settings->whatsapp_type) ? "selected" : ""; ?>><?php echo trans('wazfy') ?></option>
                                      <option value="wappblaster" <?php echo ('wappblaster' == $this->business->whatsapp_type) ? "selected" : ""; ?>><?php echo trans('wappblaster') ?></option>
                                  </select>
                                </div>
                              </div>


                              <div class="col-md-6">
                                <div class="card-body bdk mb-3">
                                  <div class="form-group">
                                    <p><a class="text-<?php if($settings->whatsapp_type == 'ultramsg'){echo "primary";}else{echo "dark";} ?> fs-18 font-weight-bold" target="_blank" href="https://ultramsg.com"><?php echo trans('ultramsg') ?> <i class="bi bi-link-45deg"></i></a></p>
                                  </div>

                                  <div class="form-group">
                                    <label><?php echo trans('instance-id') ?></label>
                                      <input type="text" name="ultramsg_instance_id" value="<?php echo html_escape($settings->ultramsg_instance_id); ?>" class="form-control" >
                                  </div>

                                  <div class="form-group">
                                    <label><?php echo trans('token') ?></label>
                                      <input type="text" name="ultramsg_token" value="<?php echo html_escape($settings->ultramsg_token); ?>" class="form-control" >
                                  </div>
                                </div>
                              </div>


                              <div class="col-md-6">
                                <div class="card-body bdk mb-3">
                                  <div class="form-group">
                                    <p><a class="text-<?php if($settings->whatsapp_type == 'wazfy'){echo "primary";}else{echo "dark";} ?> fs-18 font-weight-bold" target="_blank" href="https://wazfy.com"><?php echo trans('wazfy') ?> <i class="bi bi-link-45deg"></i></a></p>
                                  </div>

                                  <div class="form-group">
                                    <label><?php echo trans('instance-id') ?></label>
                                      <input type="text" name="wazfy_instance_id" value="<?php echo html_escape($settings->wazfy_instance_id); ?>" class="form-control" >
                                  </div>

                                  <div class="form-group">
                                    <label><?php echo trans('token') ?></label>
                                      <input type="text" name="wazfy_token" value="<?php echo html_escape($settings->wazfy_token); ?>" class="form-control" >
                                  </div>
                                </div>
                              </div>


                              <div class="col-md-6">
                                <div class="card-body bdk mb-3">
                                  <div class="form-group d-flex justify-content-between">
                                    <div>
                                      <p><a class="text-<?php if(settings()->whatsapp_type == 'wappblaster'){echo "primary";}else{echo "dark";} ?> fs-18 font-weight-bold" target="_blank" href="https://wappblaster.com"><?php echo trans('wappblaster') ?> <i class="bi bi-link-45deg"></i></a></p>
                                    </div>

                                    <div>
                                       <a class="btn btn-sm btn-light" target="_blank" href="<?php echo base_url('assets/images/wb.pdf') ?>"><i class="bi bi-file-text"></i> <?php echo trans('integration-docs') ?></a>
                                    </div>
                                  </div>

                                  <div class="form-group">
                                    <label><?php echo trans('webhook-key') ?></label>
                                      <input type="text" name="wappblaster_key" value="<?php echo html_escape(settings()->wappblaster_key); ?>" class="form-control" >
                                  </div>
                                </div>
                              </div>

                            </div>
                        </div>

                        <!-- pwa tab -->
                        <div class="tab-pane fade" id="pwa" role="tabpanel" aria-labelledby="pwa-tab">
                              
                              <div class="form-group">
                                <div class="custom-control custom-switch prefrence-item ml-10 mt-25">
                                    <input type="checkbox" name="enable_pwa" class="custom-control-input" value="1" id="switch-pwa" <?php if($settings->enable_pwa == 1){echo "checked";} ?>>
                                    <label class="custom-control-label" for="switch-pwa"><?php echo trans('enable-pwa') ?></label>
                                    <p class="text-muted mb-2"><small><?php echo trans('pwa-enable-title') ?></small></p>
                                </div>
                              </div>

                              <div class="form-group">
                                  <div class="col-sm-4">
                                    <div class="mih-100">
                                      <?php $pwa_thumb = !empty(settings()->pwa_logo)? settings()->pwa_logo :"assets/pwa/logo-bk.png"; ?>
                                      <img class="m-auto shadow-sm rounded" width="100px" src="<?php echo base_url($pwa_thumb); ?>">
                                    </div>

                                  <div class="form-group">
                                      <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="pwa_logo" id="customFile">
                                        <label class="custom-file-label" for="customFile"><?php echo trans('upload-logo') ?></label>
                                      </div>
                                      <p class="mt-1 small text-danger"><i class="bi bi-info-circle"></i> <?php echo trans('logo') ?> 512x512</p>
                                  </div>
                                </div>
                              </div>
                         
                        </div>


                        <!-- css tab -->
                        <div class="tab-pane fade" id="css" role="tabpanel" aria-labelledby="script-tab">
                            <div class="form-group">
                              <label><?php echo trans('add-your-own-css-code-here') ?></label>
                              <textarea class="form-control" name="custom_css" rows="16"><?php echo json_decode($settings->custom_css) ?></textarea>
                            </div>
                        </div>
                        

                        <!-- tax tab -->
                        <div class="tab-pane fade" id="tax" role="tabpanel" aria-labelledby="tax-tab">
                          <div class="col-5">
                            <div class="form-group">
                              <label><?php echo trans('tax-name') ?></label>
                                <input type="text" name="tax_name" value="<?php echo html_escape($settings->tax_name); ?>" class="form-control" >
                            </div>
                            
                              <div class="form-group">
                                <label><?php echo trans('tax-amount') ?></label>
                                <div class="input-group">
                                  <input type="text" class="form-control" name="tax_value" value="<?php echo html_escape($settings->tax_value); ?>">
                                  <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                  </div>
                                </div>
                              </div>
                          </div>
                        </div>


                        <!-- mail tab -->
                        <div class="tab-pane fade" id="mail" role="tabpanel" aria-labelledby="mail-tab">
                            
                          <div class="col-sm-12 mt-15">

                              <div class="callout callout-default smtp_area <?php if(settings()->mail_protocol == 'mail'){echo "d-hide";} ?>">
                                  <h5><?php echo trans('gmail-smtp') ?></h5>
                                  <p>Gmail Host:&nbsp;&nbsp;smtp.gmail.com <br>
                                   Port:&nbsp;&nbsp;SSL 465 & TLS 587</p>

                                  <p class="text-dark mb-2"><b><i class="fa fa-info-circle"></i> <?php echo trans('mail-info-title') ?></b></p>
                                  <p><i class="fas fa-times-circle text-danger"></i> <?php echo trans('two-factor-authentication-off') ?><br>
                                  <i class="fas fa-check-circle text-success"></i> <?php echo trans('less-secure-app-on') ?></p>
                              </div>

                              <div class="form-group">
                                  <label class="control-label"><?php echo trans('mail-type') ?></label>
                                  <select name="mail_protocol" class="form-control custom-select mail_protocol">
                                      <option value="smtp" <?php echo ($settings->mail_protocol == "smtp") ? "selected" : ""; ?>>SMTP</option>
                                      <option value="mail" <?php echo ($settings->mail_protocol == "mail") ? "selected" : ""; ?>>Codeigniter Mail</option>
                                  </select>
                              </div>

                              <div class="form-group">
                                  <label class="control-label"><?php echo trans('mail-title') ?></label>
                                  <input type="text" class="form-control" name="mail_title" value="<?php echo html_escape($settings->mail_title); ?>">
                              </div>

                              <div class="form-group">
                                  <label class="control-label"><?php echo trans('sender-email') ?></label>
                                  <input type="text" class="form-control" name="sender_mail" value="<?php if(empty($settings->sender_mail)){ echo html_escape($settings->admin_email);} else{echo html_escape($settings->sender_mail);} ?>">
                              </div>

                              <div class="smtp_area <?php if(settings()->mail_protocol == 'mail'){echo "d-hide";} ?>">
                                <div class="form-group">
                                    <label class="control-label"><?php echo trans('mail-host') ?></label>
                                    <input type="text" class="form-control" name="mail_host" value="<?php echo html_escape($settings->mail_host); ?>">
                                </div>

                                <div class="form-group">
                                    <label class="control-label"><?php echo trans('mail-port') ?></label>
                                    <input type="text" class="form-control" name="mail_port" value="<?php echo html_escape($settings->mail_port); ?>">
                                </div>

                                <div class="form-group">
                                    <label class="control-label"><?php echo trans('mail-username') ?></label>
                                    <input type="text" class="form-control" name="mail_username" value="<?php echo html_escape($settings->mail_username); ?>" autocomplete="off">
                                </div>

                                <div class="form-group">
                                    <label class="control-label"><?php echo trans('mail-password') ?></label>
                                    <input type="password" class="form-control" name="mail_password" value="<?php echo base64_decode($settings->mail_password); ?>" autocomplete="off">
                                </div>

                                <div class="form-group">
                                    <label class="control-label"><?php echo trans('mail-encryption') ?></label>
                                    <select name="mail_encryption" class="form-control custom-select">
                                        <option value="ssl" <?php echo ($settings->mail_encryption == "ssl") ? "selected" : ""; ?>>SSL</option>
                                        <option value="tls" <?php echo ($settings->mail_encryption == "tls") ? "selected" : ""; ?>>TLS</option>
                                    </select>
                                    <p class="small"><i class="fa fa-info-circle"></i> <?php echo trans('mail-port-help') ?> </p>
                                </div>
                              </div>

                          
                              <div class="form-group">
                                <a target="_blank" href="<?php echo base_url('auth/test_mail') ?>" class="btn btn-secondary mb-50 pull-right"><i class="fa fa-paper-plane"></i> <?php echo trans('send-test-mail') ?></a>
                              </div>
                          </div>

                        </div>

                        <!-- script tab -->
                        <div class="tab-pane fade" id="script" role="tabpanel" aria-labelledby="script-tab">
                            <div class="form-group">
                              <label><?php echo trans('header-script-codes-title') ?></label>
                              <textarea class="form-control" name="google_analytics" rows="16"><?php echo base64_decode($settings->google_analytics) ?></textarea>
                            </div>
                        </div>


                        <!-- social tab -->
                        <div class="tab-pane fade" id="social" role="tabpanel" aria-labelledby="social-tab">
                            <div class="form-group">
                              <label><?php echo trans('facebook') ?></label>
                                <input type="text" name="facebook" value="<?php echo html_escape($settings->facebook); ?>" class="form-control" >
                            </div>
                            <div class="form-group">
                              <label><?php echo trans('twitter') ?></label>
                                <input type="text" name="twitter" value="<?php echo html_escape($settings->twitter); ?>" class="form-control" >
                            </div>
                            <div class="form-group">
                              <label><?php echo trans('instagram') ?></label>
                                <input type="text" name="instagram" value="<?php echo html_escape($settings->instagram); ?>" class="form-control" >
                            </div>
                            <div class="form-group">
                              <label><?php echo trans('linkedin') ?></label>
                                <input type="text" name="linkedin" value="<?php echo html_escape($settings->linkedin); ?>" class="form-control" >
                            </div>
                        </div>

                        <!-- captcha tab -->
                        <div class="tab-pane fade" id="captcha" role="tabpanel" aria-labelledby="captcha-tab">
                            <div class="form-group mb-4">
                              <label><?php echo trans('recaptcha') ?></label>
                              <?php if (settings()->captcha_site_key != ''): ?>
                                  <div class="g-recaptcha pull-left m-10" data-sitekey="<?php echo html_escape(settings()->captcha_site_key); ?>"></div>
                              <?php endif ?>
                            </div>

                            <div class="form-group">
                              <label><?php echo trans('captcha-site-key') ?></label>
                                <input type="text" name="captcha_site_key" value="<?php echo html_escape($settings->captcha_site_key); ?>" class="form-control" >
                            </div>

                            <div class="form-group">
                              <label><?php echo trans('captcha-secret-key') ?></label>
                                <input type="text" name="captcha_secret_key" value="<?php echo html_escape($settings->captcha_secret_key); ?>" class="form-control" >
                            </div>
                        </div>

                        <!-- css tab -->
                        <div class="tab-pane fade" id="api" role="tabpanel" aria-labelledby="script-tab">
                          <div class="d-flex justify-content-between mb-3">
                            <a href="<?php echo base_url('admin/dashboard/generate_api_key') ?>" class="btn btn-light-success mb-3"><i class="bi bi-plus-circle-dotted"></i> Generate Api Key</a>

                            <a href="<?php echo base_url('admin/dashboard/api') ?>" class="btn btn-outline-danger mb-3 pull-right"><i class="bi bi-file-text"></i> Api Documentation</a>
                          </div>

                            <div class="input-group">
                              <input type="text" class="form-control copy_url bg-light" placeholder="" name="api" value="<?php echo html_escape($settings->api_key); ?>" aria-label="Recipient's username" aria-describedby="basic-addon2">
                              <div class="input-group-append">
                                <a href="#" class="btn btn-outline-primary btn-md px-4 copy_button" type="button"><i class="fas fa-clone"></i></a>
                              </div>
                            </div>
                            <div id="successMsg" class="text-success"></div>
                        </div>
                      </div>

                      <!-- csrf token -->
                      <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

                      <button type="submit" class="btn btn-primary btn-lg btn-block mt-3 fs-15"> <?php echo trans('save-changes') ?></button>
                        
                    </form>
                  </div>
                </div>
                
              </div>
            </div>

          </div>
          <!-- /.col-md-6 -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content -->
</div>
