<?php include"topbar.php"; ?>

<section class="pt-0 cus-account">
    <div class="container cw-14">
        <div class="row mb-100">
            <div class="col-md-3">
                <?php include'side_menu.php'; ?>
            </div>

            <div class="col-md-9">
                <div class="card shadow-sm br-10 over-hiddens mb-4">
                    <div class="card-header bg-white px-5 py-2 mt-3">
                        <div class="row">
                            <div class="col-md-6">
                                <h5 class="card-title font-weight-normal"><?php echo trans('appointments') ?> <span class="count"><?php echo count($appointments) ?></span> </h5>
                            </div>
                            
                            
                            <div class="col-md-6">
                                <form class="sort_form" method="get" action="<?php echo base_url('staff/appointments') ?>">
                                    <div class="input-group mt--8">
                                        <input type="text" class="form-control daterange" name="daterange" aria-describedby="button-addon2" autocomplete="off" placeholder="Select date">
                                        <div class="input-group-append">
                                            <button class="btn btn-secondary sort_btn" type="button" id="button-addon2"><i class="fas fa-search"></i> </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            
                        </div>
                    </div>

                    <div class="card-body bg-white p-0 table-responsive">
                        

                        <!-- new items style -->
                        <div class="d-nones accordion" id="accordionExample">

                            <div class="cards">
                                <div class="card-header bg-gray hide-xs">
                                    <div class="row">
                                      <div class="col-md-7 d-flex align-items-center">
                                          <h5 class="mb-0">Service Info</h5>
                                      </div>
                                      <div class="col-md-3">
                                        <h5 class="mb-0">Customer</h5>
                                      </div>
                                      <div class="col-md-2 text-right">
                                        <h5 class="mb-0"></h5>
                                      </div>
                                    </div>
                                </div>
                            </div>

                            <?php $a=1; foreach ($appointments as $appointment): ?>
                                <div class="cards">
                                    <div class="card-header bg-<?php if($a % 2 == 0){echo "gray";} ?>" id="headingOne_<?php echo html_escape($appointment->id) ?>">
                                      
                                            <div class="row">
                                                <div class="col-md-7 align-items-center">
                                                   
                                                    <?php 
                                                        $check_coupon = check_coupon($appointment->id, $appointment->service_id, $appointment->business_id);
                                                        if ($check_coupon != FALSE):
                                                            if (!empty($check_coupon)):
                                                                $price =  get_price($appointment->price, $appointment->group_booking, $appointment->total_person);
                                                                $discount = $check_coupon->discount;
                                                                $amount = $price - ($price * ($discount / 100));
                                                                $discount_amount = $price - $amount;
                                                            else:
                                                                $price =  get_price($appointment->price, $appointment->group_booking, $appointment->total_person);
                                                                $discount = 0;
                                                                $discount_amount = 0;
                                                                $amount = $price;
                                                            endif;
                                                        else:

                                                            $discount = 0;
                                                            $amount =  get_price($appointment->price, $appointment->group_booking, $appointment->total_person);
                                                        endif;

                                                        //calculate service tax
                                                        if ($company->tax_type != 0):
                                                            if ($company->tax_type == 1 && $company->tax_amount > 0):
                                                                $amount = str_replace(',','', get_tax($amount,  $company->tax_amount));
                                                            endif;

                                                            $service = $this->admin_model->get_by_id($appointment->service_id, 'services');
                                                            if ($company->tax_type == 2 && $service->tax > 0):
                                                                $amount = str_replace(',','', get_tax($amount,  $service->tax));
                                                            endif;
                                                        endif;
                                                    ?>

                                                    <p class="mb-1">
                                                        <span class="mb-1 mr-1 smalls badge badge-sm badge-secondary-soft fs-12">#<?php echo html_escape($appointment->number) ?></span>
                                                        <?php if ($discount != 0): ?>
                                                          <span class="mb-1 mr-1 smalls badge badge-sm badge-secondary-soft fs-12">
                                                              <?php echo html_escape($discount) ?>% <?php echo trans('off') ?> 
                                                          </span>
                                                        <?php endif ?>

                                                        <span class="mb-1 mr-1 smalls badge badge-sm badge-secondary-soft fs-12">
                                                            <?php if ($appointment->price == 0): ?>
                                                                <?php echo trans('free') ?> 
                                                            <?php else: ?>
                                                                <?php $amount = get_appointment_price($appointment, $company) ?>
                                                                <?php if($company->curr_locate == 0){echo get_currency_by_country($company->country)->currency_symbol;} ?><?php echo number_format($amount, $company->num_format) ?> <?php if($company->curr_locate == 1){echo get_currency_by_country($company->country)->currency_symbol;} ?> 
                                                            <?php endif ?>
                                                        </span>
                                                        
                                                        <span class="mb-1 mr-1 smalls badge badge-sm badge-secondary-soft fs-12"><i class="bi bi-clock"></i> <?php echo html_escape($appointment->duration).' '.trans($appointment->duration_type) ?> </span> 

                                                        <span class="mb-1 mr-1 smalls badge badge-sm badge-secondary-soft fs-12"><i class="far fa-calendar-alt"></i> <?php echo my_date_show($appointment->date) ?></span> 

                                                        <?php if ($appointment->duration_type != 'day'): ?>
                                                        <span class="mb-1 mr-1 smalls badge badge-sm badge-secondary-soft fs-12"><i class="bi bi-clock-fill"></i> <?php echo format_time($appointment->time, $company->time_format) ?></span>
                                                        <?php endif ?>

                                                        <?php if ($appointment->status == 0): ?>
                                                            <span class="mb-1 mr-1 smalls badge badgesm badge-warning-soft fs-12"><i class="far fa-circle fs-13"></i> <?php echo trans('pending') ?></span>
                                                        <?php elseif ($appointment->status == 1): ?>
                                                            <span class="mb-1 mr-1 smalls badge badgesm badge-success-soft fs-12"><i class="far fa-circle fs-13"></i> <?php echo trans('approved') ?></span>
                                                        <?php elseif ($appointment->status == 2): ?>
                                                            <span class="mb-1 mr-1 smalls badge badgesm badge-danger-soft fs-12"><i class="far fa-circle fs-13"></i> <?php echo trans('rejected') ?></span>
                                                        <?php elseif ($appointment->status == 3): ?>
                                                            <span class="mb-1 mr-1 smalls badge badgesm badge-primary-soft fs-12"><i class="far fa-circle fs-13"></i> <?php echo trans('completed') ?></span>
                                                        <?php endif ?>

                                                        <?php 
                                                            $amp_payment = appointment_payment_details($appointment->id);
                                                            if (!empty($amp_payment) && $amp_payment->status == 'verified') {
                                                              $check_payment = true;
                                                            }else{
                                                              $check_payment = false;
                                                            }
                                                        ?>

                                                        <?php if ($check_payment == true): ?>
                                                            <?php if ($amp_payment->pay_later != '0'): ?>
                                                              <span class="mb-1 mr-1 smalls badge badgesm badge-success-soft fs-12"><i class="fas fa-check-circle"></i>
                                                               <?php echo trans('partially-paid') ?>
                                                              </span>

                                                              <span class="mb-1 mr-1 smalls badge badgesm badge-danger-soft fs-12">
                                                                <?php echo trans('due') ?> 
                                                                <?php $amount = get_appointment_price($appointment, $this->business) ?>
                                                                <?php if($this->business->curr_locate == 0){echo $this->business->currency_symbol;} ?>
                                                                <?php echo number_format($amp_payment->pay_later, $this->business->num_format) ?>
                                                                <?php if($this->business->curr_locate == 1){echo $this->business->currency_symbol;} ?>
                                                              </span>
                                                            <?php else: ?>
                                                              <span class="mb-1 mr-1 smalls badge badgesm badge-success-soft fs-12"><i class="fas fa-check-circle"></i> <?php echo trans('paid').' '.trans('payment') ?></span>
                                                            <?php endif ?>

                                                        <?php else: ?>
                                                            <?php if ($appointment->price != 0): ?>
                                                                <span class="mb-1 mr-1 smalls badge badgesm badge-warning-soft fs-12"><i class="bi bi-hourglass-top"></i> <?php echo trans('pending').' '.trans('payment') ?></span>
                                                            <?php endif ?>
                                                        <?php endif; ?>


                                                        <?php if(!empty($appointment->service_extra)): ?>
                                                            <span class="mt-0"><a data-toggle="modal" href="#extraServiceModal_<?php echo $a ?>" class="mb-1 mr-1 smalls badge badge-sm badge-primary-soft fs-12"><i class="bi bi-eye-fill"></i> <?php echo trans('booked-service-extra') ?> </a></span>
                                                        <?php endif; ?>

                                                        <?php if ($appointment->group_booking != 0): ?>
                                                        <span class="mb-1 mr-1 smalls badge badgesm badge-success-soft fs-12"><i class="bi bi-people"></i> <?php echo trans('group-booking') ?> - <?php echo $appointment->total_person + 1 ?> </span>
                                                        <?php endif ?>
                                                    </p>


                                                    <p class="font-weight-bold fs-15"> <?php echo html_escape($appointment->service_name) ?> </p>

                                                    <p class="mb-1">
                                                    <?php if ($appointment->location_id != 0): ?>
                                                        <span class="mb-1">
                                                            <i class="bi bi-geo-alt-fill"></i> <?php echo get_by_id($appointment->location_id, 'locations')->name ?>
                                                        </span>
                                                    <?php endif ?>
                                                    <?php if ($appointment->sub_location_id != 0): ?>
                                                        <span class="mb-0">
                                                            <i class="bi bi-arrow-right"></i> <?php echo get_by_id($appointment->sub_location_id, 'locations')->name ?> (<?php echo get_by_id($appointment->sub_location_id, 'locations')->address ?>)</span>
                                                    <?php endif ?>
                                                    </p>
                                                  </div>

                                                  <div class="col-md-3">
                                                    <p class="font-weight-bold mb-0"><?php echo html_escape($appointment->customer_name) ?></p>

                                                    <?php if (!empty($appointment->customer_email)): ?>
                                                        <?php echo html_escape($appointment->customer_email) ?> <br>
                                                    <?php endif ?>

                                                    <?php if (!empty($appointment->customer_phone)): ?>
                                                        <?php echo html_escape($appointment->customer_phone) ?> <br>
                                                    <?php endif ?>

                                                    <?php 
                                                        $ctzone = get_by_id($appointment->customer_id, 'customers');
                                                        echo get_by_id($ctzone->time_zone, 'time_zone')->name 
                                                    ?>
                                                  </div>
                                                  <div class="col-md-2 text-right">
                                                    <?php if (!empty(settings()->google_client_id) && !empty(settings()->google_client_secret)): ?>
                                                        <?php if (check_user_feature_access($appointment->user_id, 'google-calendar-sync') == TRUE): ?>
                                                            <?php if ($appointment->sync_calendar_staff != 1): ?>
                                                                <a data-toggle="tooltip" data-title="<?php echo trans('sync-google-calendar') ?>" target="_blank" href="<?php echo base_url('staff/sync/'.md5($appointment->id)) ?>" class="btn btn-light-danger btn-sm"><i class="fas fa-calendar-check"></i></a>
                                                            <?php endif ?>
                                                        <?php endif ?>
                                                    <?php endif ?>

                                                    <a class="btn btn-light-primary btn-sm" href="#editModal_<?= $appointment->id; ?>" data-toggle="modal"><i class="lni lni-pencil"></i></a>
                                                </div>
                                            </div>
                                       
                                    </div>

                                    <div id="collapse_<?php echo html_escape($appointment->id) ?>" class="collapse" aria-labelledby="headingOne_<?php echo html_escape($appointment->id) ?>" data-parent="#accordionExample">
                                      <div class="card">
                                        <div class="card-body row px-6">
                                            <div class="col-md-12">
                                                te
                                            </div>
                                        </div>
                                      </div>
                                    </div>
                                </div>
                            <?php $a++; endforeach ?>


                        </div>
                        <!-- new items style -->
                    </div>
                </div>

                <div class="col-md-12 text-center mt-4">
                    <?php echo $this->pagination->create_links(); ?>
                </div>
            </div>
        </div>
    </div>
</seciton>



<!-- Modal -->
<?php $i=1; foreach ($appointments as $appointment): ?>
    <div class="modal fade d-hide" id="editModal_<?= $appointment->id; ?>" aria-hidden="true">
        <div class="modal-dialog">
        
            <form method="post" enctype="multipart/form-data" class="validate-form" action="<?php echo base_url('staff/update_appointment/'.$appointment->id)?>" role="form" novalidate>
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title"><?php echo trans('edit-appointment') ?></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <div class="form-group d-hide">
                            <label><?php echo trans('services') ?> <span class="text-danger">*</span></label>
                            <select class="form-control select2s" name="service_id">
                                <option value=""><?php echo trans('services') ?></option>
                                <?php foreach ($services as $service): ?>
                                <option value="<?php echo html_escape($service->id) ?>" <?php if ($appointment->service_id == $service->id){echo "selected";} ?>><?php echo html_escape($service->name) ?></option>
                                <?php endforeach ?>                 
                            </select>
                        </div>
                        
                        <div class="form-group d-hide">
                            <label><?php echo trans('customers') ?> <span class="text-danger">*</span></label>
                            <select class="form-control select2s" name="customer_id">
                                <option value=""><?php echo trans('customers') ?></option>
                                <?php foreach ($customers as $customer): ?>
                                <option value="<?php echo html_escape($customer->id) ?>" <?php if ($appointment->customer_id == $customer->id){echo "selected";} ?>><?php echo html_escape($customer->name) ?></option>
                                <?php endforeach ?>                 
                            </select>
                        </div>
                        
                        <div class="form-group d-show">
                            <label><?php echo trans('status') ?> <span class="text-danger">*</span></label>
                            <select name="status" class="select2s form-control">
                                <option value="0" <?php if($appointment->status == 0){echo "selected";} ?>> <?php echo trans('pending') ?></option>
                                <option value="1" <?php if($appointment->status == 1){echo "selected";} ?>> <?php echo trans('approved') ?></option>
                                <option value="2" <?php if($appointment->status == 2){echo "selected";} ?>> <?php echo trans('rejected') ?></option>
                                <option value="3" <?php if($appointment->status == 3){echo "selected";} ?>> <?php echo trans('completed') ?></option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label><?php echo trans('date') ?> <span class="text-danger">*</span></label>
                            <div class="input-group">
                            <input type="text" name="date" class="form-control datepicker" required placeholder="Booking date" autocomplete="off" value="<?php echo html_escape($appointment->date); ?>">
                            <span class="input-group-append">
                                <button type="button" class="btn btn-secondary"><i class="fas fa-calendar-alt"></i></button>
                            </span>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <?php list ($start_time, $end_time) = explode('-', trim($appointment->time)); ?>
                            <div class="col-sm-6">
                                <label><?php echo trans('start-time') ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="far fa-clock"></i></span>
                                    </div>
                                    <input type="text" class="form-control timepicker" name="start_time" value="<?php if (isset($start_time)){echo html_escape($start_time);} ?>" autocomplete="off">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <label><?php echo trans('end-time') ?> <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="far fa-clock"></i></span>
                                    </div>
                                    <input type="text" class="form-control timepicker" name="end_time" value="<?php if (isset($end_time)){echo html_escape($end_time);} ?>" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal-footer justify-content-between">
                        <!-- csrf token -->
                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                        <button type="submit" class="btn btn-primary btn-block"><?php echo trans('save-changes') ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $i++; endforeach; ?>
<!-- End Modal -->




<?php if (!empty($appointments)): ?>
  <?php $q=1; foreach ($appointments as $appointment): ?>

    <div class="modal fade d-hide" id="extraServiceModal_<?= $q; ?>" aria-hidden="true">
      <div class="modal-dialog modal-lg">
      
        
        <?php $service_extras = explode(',', $appointment->service_extra); ?>
          <div class="modal-content">
            <div class="modal-header border-0">
            <h4 class="modal-title">
                <?php echo trans('service-extra') ?> of - <?php echo get_by_id($appointment->service_id,'services')->name ?>
            </h4>
              <div class="mclose" data-dismiss="modal"><i class="lnib lni-close"></i></div>
            </div>

            <?php if(!empty($appointment->service_extra)): ?>
              <div class="modal-body mb-4">
                <?php $business = $this->admin_model->get_company($appointment->user_id) ?>

                <?php foreach ($service_extras as $value): ?>
                  <?php $service_extra = get_by_id($value,'service_extra'); ?>
                  <div class="row px-4 py-3 bg-light mx-2 my-3">
                    <div class="col-md-6">
                      <p class="mb-0 text-dark"><i class="bi bi-check-circle-fill"></i> <?php echo html_escape($service_extra->name) ?></p>
                    </div>

                    <div class="col-md-3">
                      <p class="mb-0 text-dark">
                        <?php if($company->curr_locate == 0){echo get_currency_by_country($company->country)->currency_symbol;} ?>
                        <?php echo number_format($service_extra->price, $company->num_format) ?>
                        <?php if($company->curr_locate == 1){echo get_currency_by_country($company->country)->currency_symbol;} ?>
                      </p>
                    </div>
                    <div class="col-md-3">
                      <p class="mb-0 text-dark">
                        <i class="far fa-clock"></i> <?php echo html_escape($appointment->duration).' '.trans($appointment->duration_type); ?>
                      </p>
                    </div>
                  </div>
                <?php endforeach ?>
             
              </div>
            <?php else: ?>
              <?php $this->load->view('admin/include/not-found') ?>
            <?php endif; ?>

          </div>

        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
  <?php $q++; endforeach; ?>
<?php endif; ?>